<?php

$root = $_SERVER['DOCUMENT_ROOT'];

include $root.'/wp-load.php';
include $root.'/wp-admin/includes/taxonomy.php';
include $root.'/tool/functions.php';


// Google Gemini API key
$gemini_api_key = 'AIzaSyCHhAOpvoB_asM2r9MeigZuuRhttXh-M_c';

// Google Trends RSS Feed
$feed_url = 'https://trends.google.com/trending/rss?geo=PK&hours=4&status=active&nocache='.time().'';


// 🚀 Main execution
try {
    $topics = getTrendingTopics($feed_url);
 
    if (!empty($topics)) {
        foreach($topics as $topic){
            
        $keyword = trim($topic['keyword']);
        $titles = $topic['titles'];
        $urls = $topic['urls'];
     

         if (focusKeywordExists($keyword)) {
            continue;
        }
        

        $categoryPrompt = buildCategoryPrompt($keyword, $titles);
        $categoryName = askGemini($categoryPrompt, $gemini_api_key); // This will return something like "Sports News"
        $categoryName = trim($categoryName); // remove any extra whitespace or newlines
       

        $seoPrompt = buildSeoTitleMetaPrompt($keyword, $titles);
        $seoResponse = askGemini($seoPrompt, $gemini_api_key);
        $seoData = extractSeoData($seoResponse);

        $articlePrompt = buildFullArticlePrompt($keyword, $titles);
        $article = askGemini($articlePrompt, $gemini_api_key);
        
       
        $seo_title = htmlspecialchars($seoData['seo_title']);
        $seo_description = htmlspecialchars($seoData['meta_description']);
        $post_content = $article;
        $pid = insert_gemini_article_to_wp($seo_title, $post_content, $keyword, $seo_description,$categoryName);
        $featured_img_src = '';
        foreach($urls as $url){
           $ogimage = getOgImage($url);
           if($ogimage){
               $featured_img_src = $ogimage;
               break;
           }
        }
        
        processRemoteImageToFeatured($featured_img_src, $pid); 
        
        echo 'posted';
        break;
        }

    } else {
        echo "No trending topics found.";
    }

} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
